// (c) 1999 - 2025 OneSpan North America Inc. All rights reserved.


/////////////////////////////////////////////////////////////////////////////
//
//
// This file is example source code. It is provided for your information and
// assistance. See your licence agreement for details and the terms and
// conditions of the licence which governs the use of the source code. By using
// such source code you will be accepting these terms and conditions. If you do
// not wish to accept these terms and conditions, DO NOT OPEN THE FILE OR USE
// THE SOURCE CODE.
//
// Note that there is NO WARRANTY.
//
//////////////////////////////////////////////////////////////////////////////


import Foundation
import MSSNotificationClient

class NotificationManager {
    func registerForNotifications() {
        do {
            // Make sure we are activated (user could have deleted the digipass )
            // Get activated user from shared preferences
            guard SharedPreferenceStorage.getActivatedUser() != nil else { return }
            
            // Register to all available notification types
            try NotificationClientSDK.registerNotificationServices(withType: [.alert, .sound, .badge])
        } catch let error as NotificationError {
            let message = "\("error_notification_registration".localized): \(error.formatted)"
            NotificationCenter.default.post(name: .managerErrorWithParse, object: message)
            print(message)
        } catch {
            assertionFailure("notification_error_not_known".localized)
        }
    }
    
    func registrationSucceeded(deviceToken: Data) {
        NotificationCenter.default.post(name: .managerNewDeviceToken, object: deviceToken)
    }
    
    func registrationFailed() {
        // Ignore
    }
    
    // MARK: handle notification
    func notificationReceived(notificationDictionary: [AnyHashable: Any]) {
        notificationReceived(notificationDictionary: notificationDictionary) {}
    }

    func notificationReceived(notificationDictionary: [AnyHashable: Any], consumingBlock: @escaping () -> Void) {
        if NotificationClientSDK.isOneSpanNotification(notificationDictionary) {
            parseOnseSpanNotification(notificationDictionary, consumingBlock: consumingBlock)
        } else {
            NotificationCenter.default.post(name: .managerErrorWithParse, object: "notification_recieved_non_onespan".localized)
        }
    }
    
    private func parseOnseSpanNotification(_ notificationDictionary: [AnyHashable: Any], consumingBlock: @escaping () -> Void) {
        if let notificationContent = NotificationClientSDK.oneSpanNotification(from: notificationDictionary) {
            NotificationCenter.default.post(name: .managerPending, object: notificationContent)
            
            // Consume the notification in the main thread
            DispatchQueue.main.async {
                consumingBlock()
            }
        } else {
            let message = "notification_unable_to_parse".localized
            NotificationCenter.default.post(name: .managerErrorWithParse, object: message)
            print(message)
            print(notificationDictionary)
        }
    }
}
